'**************************************************************************
'*                                                                        *
'*   File Name      :  4462_rs.bas      Version: V 200001 deu             *
'*                                                                        *
'*   entwickelt von :  Thomas Meder     am 2000.02.22                     *
'*   gendert von   :                   am YYYY.MM.DD                     *
'*                                                                        *
'*   Sprache        :  QBASIC 4.5       Betriebssystem: MS-DOS 6.22       *
'*                                                                        *
'*   Beschreibung   :  Beispielprogramm zum senden und empfangen von      *
'*                     SCPI-Befehlen an den Digistanten Typ 4462          *
'*                     ber die Schnittstelle RS 232 an COM1              *
'*                                                                        *
'*   Konfiguration:    9600 BAUD, 8 DATENBITS, 1 STOPPBIT, keine PARITT  *
'*                                                                        *
'*   Protokoll:        ANSI X3.28 -  1976                                 *
'*                                                                        *
'*   Copyright by burster przisionsmesstechnik, Gernsbach 07224-6450     *
'*                                                                        *
'**************************************************************************

DIM choice$(10)
DIM char$(10)
DIM befehl$(50)
DIM val$(50)
DIM msg$(50)
DIM antwort$(50)

REM Definition der Sonderzeichen:
STX$ = CHR$(2)
ETX$ = CHR$(3)
EOT$ = CHR$(4)
LF$ = CHR$(10)
ACK$ = CHR$(6)
NAK$ = CHR$(21)

REM Initialisierung der seriellen Schnittstelle COM1 des PC:
OPEN "COM1:9600,N,8,1,RS" FOR RANDOM AS #3

CLS     'Bildschirm lschen

PRINT "**********************************************************************"
PRINT "* Dies ist ein Beispielprogramm zum steuern des DIGISTANTEN TYP 4462 *"
PRINT "* ber die Schnittstelle RS 232 an COM1                              *"
PRINT "* Konfiguration: 9600 BAUD, 8 DATENBITS, 1 STOPPBIT, keine PARITT   *"
PRINT "**********************************************************************"
PRINT
PRINT
PRINT " Bitte whlen Sie die gewnschte Funktion:"
PRINT " ========================================="
PRINT " Spannungswert ausgeben      :   1"
PRINT " Stromwert ausgeben          :   2"
PRINT " Eingestellter Wert abfragen :   3"
PRINT " ABBRUCH                     :  <#>"


WHILE choice$ <> "#"                    'Solange Taste <#> nicht gedrckt
LOCATE 16, 1                            'Textausgaben auf Bildschirm lschen
PRINT "                                                                             "
LOCATE 16, 1
INPUT " Bitte Auswahl treffen: "; choice$  'Auswahl bernehmen

LOCATE 18, 1                            'Textausgaben auf Bildschirm lschen
PRINT "                                                                             "
LOCATE 20, 1
PRINT "                                                                             "
LOCATE 22, 1
PRINT "                                                                             "
befehl$ = ""

IF (choice$ = "1") THEN                 'Spannungswert ausgeben
  GOSUB SENDVOLTAGE
END IF
IF (choice$ = "2") THEN                 'Stromwert ausgeben
  GOSUB SENDCURRENT
END IF
IF (choice$ = "3") THEN                 'Eingestellter Wert abfragen
  GOSUB GETVALUE
END IF
WEND

CLS
END                                     'Programm beenden
SYSTEM

SENDVOLTAGE:                            'Subroutine: Spannungswert senden
LOCATE 16, 1
INPUT " Bitte Spannungswert mit Einheit (UV, MV, V) eingeben: "; val$
befehl$ = "SOUR:VOLT " + val$           'Befehl zusammensetzen
GOSUB SENDBEFEHL                        'Befehl senden
RETURN

SENDCURRENT:                            'Subroutine: Stromwert senden
LOCATE 16, 1
INPUT " Bitte Stromwert mit Einheit (UA, MA) eingeben: "; val$
befehl$ = "SOUR:CURR " + val$           'Befehl zusammensetzen
GOSUB SENDBEFEHL                        'Befehl senden
RETURN

GETVALUE:                               'Subroutine: Eingestellter Wert abholen
befehl$ = "SOUR:VOLT?"                  'Befehl zusammensetzen
GOSUB SENDBEFEHL                        'Befehl senden
GOSUB GETMESSAGE                        'Antwort einholen
RETURN

SENDBEFEHL:                             'Subroutine: Befehl senden
msg$ = STX$ + befehl$ + LF$ + ETX$      'Befehlstring zusammensetzen
PRINT #3, msg$                          'Befehlstring senden
LOCATE 18, 1
PRINT " Gesendeter Befehl: ", befehl$   'Befehlsstring anzeigen
antwort$ = ""                           'Antwortstring lschen
antwort$ = INPUT$(1, #3)                'Antwort vom Gert einlesen
LOCATE 20, 1
IF (antwort$ <> ACK$) THEN              'Antwort auf Fehler berprfen
  PRINT " Gert antwortet mit <NAK> "   'Fehlermeldung anzeigen"
ELSE
  PRINT " Befehl wurde vom Gert verstanden <ACK> " 'Kein Fehler
END IF
RETURN

GETMESSAGE:                             'Subroutine: Nachricht abholen
PRINT #3, EOT$                          'EOT senden
antwort$ = ""                           'Empfangsstring lschen
char$ = INPUT$(1, #3)                   'Zeichen empfangen
WHILE (char$ <> ETX$) AND (char$ <> EOT$) 'empfangen, solange kein <ETX> oder <EOT>
  IF (char$ >= CHR$(32)) THEN           'solange kein Sonderzeichen
    antwort$ = antwort$ + char$         'Antwortstring zusammensetzen
  END IF
  char$ = INPUT$(1, #3)                 'Sonderzeichen abfangen
WEND
PRINT #3, ACK$                          '<ACK> senden
LOCATE 22, 1
PRINT " Der eingestellte Wert: "; antwort$  'Eingestellter Wert anzeigen
char$ = INPUT$(1, #3)                   '<EOT> empfangen
char$ = ""                              'Zeichen <EOT> lschen
RETURN

